C      *****************************************************************
C      * Subroutine Gauss                                              *
C      * Solves the set of simultaneous eqns represented in [A] and    *
C      * returns the solution in vector X.                             *
C      *                                                               *
C      * Variables:                                                    *
C      * Iter      -Input - The iteration number.  Unitless.           *
C      * UnitNum   -Input - The output file number.  Unitless.         *
C      *****************************************************************
       SUBROUTINE GAUSS(ITER, UNITNUM)
       INTEGER ITER, UNITNUM

C      *--------------------------------------------------------------*   
C      * Scale the [A] matrix so that largest coefficient equals 1.   *
C      * This reduces roundoff errors.                                *
C      *--------------------------------------------------------------*   
	      CALL SCALEORDER

C      *------------------------------------------------------*
C      * Transform the matrix into an upper triangular matrix.*
C      *------------------------------------------------------*
	      CALL FORWARDELIM(ITER, UNITNUM)

C      *--------------------------------------------------------------*   
C      * Using the upper triangular matrix, solve for each variable in*
C      * turn starting with the one that has only one non-zero coeff. *
C      * and back-substituting through the matrix to solve for all the*
C      * variables.                                                   *
C      *--------------------------------------------------------------*   
	      CALL BACKSUB
	   
  	    RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
